output "first_arn" {
  value       = aws_iam_user.example[0].arn
  description = "Wartość ARN dla pierwszego użytkownika"
}

output "all_arns" {
  value       = aws_iam_user.example[*].arn
  description = "Wartości ARN dla wszystkich użytkowników"
}

output "neo_cloudwatch_policy_arn_ternary" {
  value = (
    var.give_neo_cloudwatch_full_access
    ? aws_iam_user_policy_attachment.neo_cloudwatch_full_access[0].policy_arn
    : aws_iam_user_policy_attachment.neo_cloudwatch_read_only[0].policy_arn
  )
}

output "neo_cloudwatch_policy_arn" {
  value = one(concat(
    aws_iam_user_policy_attachment.neo_cloudwatch_full_access[*].policy_arn,
    aws_iam_user_policy_attachment.neo_cloudwatch_read_only[*].policy_arn
  ))
}

